//%attributes = {"publishedSql":true}
// Method: _msg_ Receive
// 2004.02.06-17:22:58 / Pasi Mankinen
// © Copyright 2004 Manage Applications
// Purpose: 
// Reads a message from the specified IPC channel. 
// If no message is available, returns an empty string.
// The option parameter can be used to keep the message in the IPC channel queue. 
// 
// ------------------------------------------------------------
C_TEXT:C284($0; $_msg_tSemName; $_msg_tErr)  //msg to receive
C_LONGINT:C283($1; $_msg_lPipeId; $2; $_msg_lKeepInQueue; $_msg_lPipeArrPos; $_msg_lMsgPos)
COMPILER__msg_
$0:=""
$_msg_lPipeId:=$1
$_msg_lKeepInQueue:=$2
$_msg_tErr:=""

$_msg_lPipeArrPos:=Find in array:C230(<>_msg_alPipeId; $_msg_lPipeId)  //find pipe
Case of 
	: ($_msg_lPipeId=0)
		_err MESSAGE(_lang Current("Message pipe id = 0"); Current method name:C684; kFalse)
	: ($_msg_lPipeArrPos<1)
		_err MESSAGE(_lang Current("Message pipe not found")+": "+String:C10($_msg_lPipeId); Current method name:C684; kFalse)
	: ($_msg_lKeepInQueue<0)
		_err MESSAGE_PARAMETER("Message keep in queue parameter < 0"; Current method name:C684; kFalse)
	: ($_msg_lKeepInQueue>1)
		_err MESSAGE_PARAMETER("Message keep in queue parameter > 1"; Current method name:C684; kFalse)
	Else 
		$_msg_tSemName:="$_msg_Pipe"+String:C10($_msg_lPipeId)
		If (_sem Set($_msg_tSemName; 60; kTrue)=kTrue)
			If (<>_msg_alPipeMsgCount{$_msg_lPipeArrPos}>0)
				
				$_msg_lMsgPos:=Position:C15(<>_msg_tPipeSeparator; <>_msg_atPipeMsg{$_msg_lPipeArrPos}; *)  //v11 ;* position Char(1) was bad in unicode
				//$_msg_lMsgPos:=_str_ AsciiFind (◊_msg_atPipeMsg{$_msg_lPipeArrPos};◊_msg_tPipeSeparator;kFalse )
				If ($_msg_lMsgPos<1)
					$_msg_tErr:="Message count is positive but messages do not exist in pipe"+": "+String:C10($_msg_lPipeId)
					$0:=<>_msg_atPipeMsg{$_msg_lPipeArrPos}  //give remaining if there is
				Else 
					$0:=Substring:C12(<>_msg_atPipeMsg{$_msg_lPipeArrPos}; 1; $_msg_lMsgPos-1)
				End if 
				If ($_msg_lKeepInQueue=0)
					If ($_msg_lMsgPos>0)
						<>_msg_atPipeMsg{$_msg_lPipeArrPos}:=Substring:C12(<>_msg_atPipeMsg{$_msg_lPipeArrPos}; $_msg_lMsgPos+1)
					Else 
						<>_msg_atPipeMsg{$_msg_lPipeArrPos}:=""  //clear rest messages on error
					End if 
					<>_msg_alPipeMsgCount{$_msg_lPipeArrPos}:=<>_msg_alPipeMsgCount{$_msg_lPipeArrPos}-1
				End if 
				
			Else 
				If (<>_msg_atPipeMsg{$_msg_lPipeArrPos}#"")
					If ($_msg_tErr#"")
						$_msg_tErr:=$_msg_tErr+ksCR
					End if 
					$_msg_tErr:=$_msg_tErr+"Message count is zero but messages exist in pipe"+": "+String:C10($_msg_lPipeId)
					<>_msg_atPipeMsg{$_msg_lPipeArrPos}:=""  //clear rest messages on error
				End if 
			End if 
			_sem CLEAR($_msg_tSemName)
			If ($_msg_tErr#"")
				_err MESSAGE($_msg_tErr; Current method name:C684; kFalse)
			End if 
		Else 
			_err MESSAGE(_lang Current("Message could not be sent"); Current method name:C684; kFalse)
		End if 
End case 
//ITK_SendIPCMsg ($_msg_lPipeId;$2)

//$0:=ITK_RcvIPCMsg ($_msg_lPipeId;$_msg_lKeepInQueue)
